/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import com.google.common.collect.ImmutableMap;
import io.github.fabricators_of_create.porting_lib.common.util.Lazy;
import io.github.fabricators_of_create.porting_lib.event.client.CreateSkullModelsCallback;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1299;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2396;
import net.minecraft.class_2484;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import net.minecraft.class_5607;
import net.minecraft.class_5617;
import net.minecraft.class_607;
import net.minecraft.class_702;
import net.minecraft.class_707;
import net.minecraft.class_836;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.ClientEventBase;
import slimeknights.tconstruct.common.registration.GeodeItemObject;
import slimeknights.tconstruct.library.client.particle.SlimeParticle;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.tools.client.SlimeskullArmorModel;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.client.SkullModelHelper;
import slimeknights.tconstruct.world.client.SlimeColorReloadListener;
import slimeknights.tconstruct.world.client.SlimeColorizer;
import slimeknights.tconstruct.world.client.TerracubeRenderer;
import slimeknights.tconstruct.world.client.TinkerSlimeRenderer;

public class WorldClientEvents
extends ClientEventBase {
    static void addResourceListener() {
        for (SlimeType type : SlimeType.values()) {
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SlimeColorReloadListener(type));
        }
    }

    static void registerParticleFactories() {
        class_702 engine = class_310.method_1551().field_1713;
        ParticleFactoryRegistry.getInstance().register((class_2396)TinkerWorld.skySlimeParticle.get(), (class_707)new SlimeParticle.Factory(SlimeType.SKY));
        ParticleFactoryRegistry.getInstance().register((class_2396)TinkerWorld.enderSlimeParticle.get(), (class_707)new SlimeParticle.Factory(SlimeType.ENDER));
        ParticleFactoryRegistry.getInstance().register((class_2396)TinkerWorld.terracubeParticle.get(), (class_707)new SlimeParticle.Factory((class_1935)class_1802.field_8696));
    }

    static void registerRenderers() {
        Lazy normalHead = Lazy.of(class_607::method_32050);
        Lazy headOverlayCustom = Lazy.of(() -> SkullModelHelper.createHeadHatLayer(0, 16, 32, 32));
        WorldClientEvents.registerLayerDefinition(TinkerHeadType.BLAZE, (Supplier<class_5607>)normalHead);
        WorldClientEvents.registerLayerDefinition(TinkerHeadType.ENDERMAN, (Supplier<class_5607>)Lazy.of(() -> SkullModelHelper.createHeadLayer(0, 0, 32, 16)));
        WorldClientEvents.registerLayerDefinition(TinkerHeadType.STRAY, (Supplier<class_5607>)headOverlayCustom);
        WorldClientEvents.registerLayerDefinition(TinkerHeadType.HUSK, (Supplier<class_5607>)Lazy.of(() -> SkullModelHelper.createHeadLayer(0, 0, 64, 64)));
        WorldClientEvents.registerLayerDefinition(TinkerHeadType.DROWNED, (Supplier<class_5607>)headOverlayCustom);
        Lazy spiderHead = Lazy.of(() -> SkullModelHelper.createHeadLayer(32, 4, 64, 32));
        WorldClientEvents.registerLayerDefinition(TinkerHeadType.SPIDER, (Supplier<class_5607>)spiderHead);
        WorldClientEvents.registerLayerDefinition(TinkerHeadType.CAVE_SPIDER, (Supplier<class_5607>)spiderHead);
        Lazy piglinHead = Lazy.of(SkullModelHelper::createPiglinHead);
        WorldClientEvents.registerLayerDefinition(TinkerHeadType.PIGLIN_BRUTE, (Supplier<class_5607>)piglinHead);
        WorldClientEvents.registerLayerDefinition(TinkerHeadType.ZOMBIFIED_PIGLIN, (Supplier<class_5607>)piglinHead);
    }

    static void registerSkullModels(ImmutableMap.Builder<class_2484.class_2485, class_5598> builder, class_5599 modelSet) {
        SkullModelHelper.HEAD_LAYERS.forEach((type, layer) -> builder.put((Object)type, (Object)new class_607(modelSet.method_32072(layer))));
    }

    static void registerRenderersSlime() {
        EntityRendererRegistry.register((class_1299)((class_1299)TinkerWorld.earthSlimeEntity.get()), (class_5617)TinkerSlimeRenderer.EARTH_SLIME_FACTORY);
        EntityRendererRegistry.register((class_1299)((class_1299)TinkerWorld.skySlimeEntity.get()), (class_5617)TinkerSlimeRenderer.SKY_SLIME_FACTORY);
        EntityRendererRegistry.register((class_1299)((class_1299)TinkerWorld.enderSlimeEntity.get()), (class_5617)TinkerSlimeRenderer.ENDER_SLIME_FACTORY);
        EntityRendererRegistry.register((class_1299)((class_1299)TinkerWorld.terracubeEntity.get()), TerracubeRenderer::new);
    }

    public static void clientSetup() {
        class_1921 cutout = class_1921.method_23581();
        class_1921 cutoutMipped = class_1921.method_23579();
        for (SlimeType type : SlimeType.values()) {
            if (type != SlimeType.BLOOD) {
                BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.slimeLeaves.get((Enum)type), cutoutMipped);
            }
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.vanillaSlimeGrass.get((Enum)type), cutoutMipped);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.earthSlimeGrass.get((Enum)type), cutoutMipped);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.skySlimeGrass.get((Enum)type), cutoutMipped);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.enderSlimeGrass.get((Enum)type), cutoutMipped);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.ichorSlimeGrass.get((Enum)type), cutoutMipped);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.slimeFern.get((Enum)type), cutout);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.pottedSlimeFern.get((Enum)type), cutout);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.slimeTallGrass.get((Enum)type), cutout);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.slimeSapling.get((Enum)type), cutout);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.pottedSlimeSapling.get((Enum)type), cutout);
        }
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.enderSlimeVine.get(), cutout);
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.skySlimeVine.get(), cutout);
        class_1921 translucent = class_1921.method_23583();
        for (SlimeType slimeType : SlimeType.TINKER) {
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.slime.get((Enum)slimeType), translucent);
        }
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.greenheart.getDoor(), cutout);
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.greenheart.getTrapdoor(), cutout);
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.skyroot.getDoor(), cutout);
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.skyroot.getTrapdoor(), cutout);
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.bloodshroom.getDoor(), cutout);
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)TinkerWorld.bloodshroom.getTrapdoor(), cutout);
        for (Enum enum_ : GeodeItemObject.BudSize.values()) {
            BlockRenderLayerMap.INSTANCE.putBlock(TinkerWorld.earthGeode.getBud((GeodeItemObject.BudSize)enum_), cutout);
            BlockRenderLayerMap.INSTANCE.putBlock(TinkerWorld.skyGeode.getBud((GeodeItemObject.BudSize)enum_), cutout);
            BlockRenderLayerMap.INSTANCE.putBlock(TinkerWorld.ichorGeode.getBud((GeodeItemObject.BudSize)enum_), cutout);
            BlockRenderLayerMap.INSTANCE.putBlock(TinkerWorld.enderGeode.getBud((GeodeItemObject.BudSize)enum_), cutout);
        }
        WorldClientEvents.registerHeadModel(TinkerHeadType.BLAZE, MaterialIds.blazingBone, new class_2960("textures/entity/blaze.png"));
        WorldClientEvents.registerHeadModel(TinkerHeadType.ENDERMAN, MaterialIds.enderPearl, TConstruct.getResource("textures/entity/skull/enderman.png"));
        SlimeskullArmorModel.registerHeadModel(MaterialIds.glass, class_5602.field_27548, new class_2960("textures/entity/creeper/creeper.png"));
        SlimeskullArmorModel.registerHeadModel(MaterialIds.bone, class_5602.field_27653, new class_2960("textures/entity/skeleton/skeleton.png"));
        SlimeskullArmorModel.registerHeadModel(MaterialIds.necroticBone, class_5602.field_27634, new class_2960("textures/entity/skeleton/wither_skeleton.png"));
        WorldClientEvents.registerHeadModel(TinkerHeadType.STRAY, MaterialIds.bloodbone, TConstruct.getResource("textures/entity/skull/stray.png"));
        SlimeskullArmorModel.registerHeadModel(MaterialIds.rottenFlesh, class_5602.field_27640, new class_2960("textures/entity/zombie/zombie.png"));
        WorldClientEvents.registerHeadModel(TinkerHeadType.HUSK, MaterialIds.iron, new class_2960("textures/entity/zombie/husk.png"));
        WorldClientEvents.registerHeadModel(TinkerHeadType.DROWNED, MaterialIds.copper, TConstruct.getResource("textures/entity/skull/drowned.png"));
        WorldClientEvents.registerHeadModel(TinkerHeadType.SPIDER, MaterialIds.string, new class_2960("textures/entity/spider/spider.png"));
        WorldClientEvents.registerHeadModel(TinkerHeadType.CAVE_SPIDER, MaterialIds.darkthread, new class_2960("textures/entity/spider/cave_spider.png"));
        WorldClientEvents.registerHeadModel(TinkerHeadType.PIGLIN_BRUTE, MaterialIds.roseGold, new class_2960("textures/entity/piglin/piglin_brute.png"));
        WorldClientEvents.registerHeadModel(TinkerHeadType.ZOMBIFIED_PIGLIN, MaterialIds.pigIron, new class_2960("textures/entity/piglin/zombified_piglin.png"));
        WorldClientEvents.addResourceListener();
        WorldClientEvents.registerParticleFactories();
        WorldClientEvents.registerRenderers();
        WorldClientEvents.registerRenderersSlime();
        WorldClientEvents.registerBlockColorHandlers();
        WorldClientEvents.registerItemColorHandlers();
        CreateSkullModelsCallback.EVENT.register(WorldClientEvents::registerSkullModels);
    }

    static void registerBlockColorHandlers() {
        for (SlimeType type : SlimeType.values()) {
            ColorProviderRegistry.BLOCK.register((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, type, null), (Object[])new class_2248[]{(class_2248)TinkerWorld.vanillaSlimeGrass.get((Enum)type), (class_2248)TinkerWorld.earthSlimeGrass.get((Enum)type), (class_2248)TinkerWorld.skySlimeGrass.get((Enum)type), (class_2248)TinkerWorld.enderSlimeGrass.get((Enum)type), (class_2248)TinkerWorld.ichorSlimeGrass.get((Enum)type)});
            ColorProviderRegistry.BLOCK.register((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, type, SlimeColorizer.LOOP_OFFSET), (Object[])new class_2248[]{(class_2248)TinkerWorld.slimeLeaves.get((Enum)type)});
            ColorProviderRegistry.BLOCK.register((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, type, null), (Object[])new class_2248[]{(class_2248)TinkerWorld.slimeFern.get((Enum)type), (class_2248)TinkerWorld.slimeTallGrass.get((Enum)type), (class_2248)TinkerWorld.pottedSlimeFern.get((Enum)type)});
        }
        ColorProviderRegistry.BLOCK.register((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, SlimeType.SKY, SlimeColorizer.LOOP_OFFSET), (Object[])new class_2248[]{(class_2248)TinkerWorld.skySlimeVine.get()});
        ColorProviderRegistry.BLOCK.register((state, reader, pos, index) -> WorldClientEvents.getSlimeColorByPos(pos, SlimeType.ENDER, SlimeColorizer.LOOP_OFFSET), (Object[])new class_2248[]{(class_2248)TinkerWorld.enderSlimeVine.get()});
    }

    static void registerItemColorHandlers() {
        WorldClientEvents.registerBlockItemColorAlias(TinkerWorld.vanillaSlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(TinkerWorld.earthSlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(TinkerWorld.skySlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(TinkerWorld.enderSlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(TinkerWorld.ichorSlimeGrass);
        WorldClientEvents.registerBlockItemColorAlias(TinkerWorld.slimeLeaves);
        WorldClientEvents.registerBlockItemColorAlias(TinkerWorld.slimeFern);
        WorldClientEvents.registerBlockItemColorAlias(TinkerWorld.slimeTallGrass);
        WorldClientEvents.registerBlockItemColorAlias(TinkerWorld.skySlimeVine);
        WorldClientEvents.registerBlockItemColorAlias(TinkerWorld.enderSlimeVine);
    }

    private static int getSlimeColorByPos(@Nullable class_2338 pos, SlimeType type, @Nullable class_2338 add) {
        if (pos == null) {
            return SlimeColorizer.getColorStatic(type);
        }
        if (add != null) {
            pos = pos.method_10081((class_2382)add);
        }
        return SlimeColorizer.getColorForPos(pos, type);
    }

    private static void registerHeadModel(TinkerHeadType skull, MaterialId materialId, class_2960 texture) {
        class_836.field_4390.put(skull, texture);
        SlimeskullArmorModel.registerHeadModel(materialId, SkullModelHelper.HEAD_LAYERS.get((Object)skull), texture);
    }

    private static class_5601 registerLayer(String name) {
        class_5601 location = new class_5601(TConstruct.getResource(name), "main");
        if (!class_5602.field_27650.add(location)) {
            throw new IllegalStateException("Duplicate registration for " + String.valueOf(location));
        }
        return location;
    }

    private static void registerLayerDefinition(TinkerHeadType head, Supplier<class_5607> supplier) {
        EntityModelLayerRegistry.registerModelLayer((class_5601)SkullModelHelper.HEAD_LAYERS.get((Object)head), supplier::get);
    }
}

